package ru.yandex.chemodan.util.search;

import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.test.ClassLoaderTestUtils;
import ru.yandex.chemodan.util.photoinfo.formatter.PhotoInfoFormatter;
import ru.yandex.chemodan.util.search.SearchResult.SearchItem;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.cl.ClassLoaderUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class SearchResultTest {

    @Test
    public void parse() {
        String json = ClassLoaderUtils.streamSourceForResource(
                SearchResult.class, "searchResult.json").readText();

        SearchResult result = SearchResult.parseSearchResult(json);
        Assert.hasSize(2, result.items);

        SearchItem item0 = result.items.get(0);

        Assert.some(1402322835L, item0.mtimeInSec);
        Assert.none(item0.latitude);
        Assert.some("/disk/image/test.jpg", item0.path);
        Assert.some("invalid json", item0.tikaiteError);
        Assert.some("16328.yadisk:1260145.163562555296473", item0.stid);

        SearchItem item1 = result.items.get(1);
        Assert.some("iPhone 4", item1.model);
        Assert.some("Apple", item1.manufacturer);
        Assert.some(new Double(30.335292), item1.longitude);
    }

    @Test
    public void parseSearchItemWithDocumentInfo() {
        String json = ClassLoaderUtils.streamSourceForResource(
                SearchResult.class, "docInfoSearchResult.json").readText();

        SearchResult result = SearchResult.parseSearchResult(json);
        Assert.hasSize(3, result.items);
        SearchItem item0 = result.items.get(0);

        Assert.some(1419186430L, item0.mtimeInSec);
        Assert.some(1419186425L, item0.ctimeInSec);
        Assert.some(1601798L, item0.size);
        Assert.some("/disk/3. читать/Mobile Photos and the Cloud_f.pdf", item0.path);
    }

    @Test
    public void parseSearchItem() {
        String json = ClassLoaderUtils.streamSourceForResource(
                SearchResult.class, "searchMulcaResult.json").readText();

        SearchItem item = SearchResult.parseSearchMulcaResult(json);
        Assert.equals(Option.of("Apple"), item.manufacturer);
    }

    @Ignore
    @Test
    public void print() {
        String json = ClassLoaderUtils.streamSourceForResource(
                SearchResult.class, "searchResult.json").readText();

        SearchResult result = SearchResult.parseSearchResult(json);
        for (SearchItem item : result.items) {
            System.out.println(new PhotoInfoFormatter().format(PassportUid.cons(12345), item));
        }
    }

    @Test
    public void parseBookInfo() {
        InputStreamSource input = ClassLoaderTestUtils.byteStreamSourceForResource(
                SearchResult.class, "bookInfoSearchResult.json");
        ListF<SearchItem> parsed = SearchResult.parseBookInfoList(input);
        Assert.equals(parsed.size(), 2);
        SearchItem first = parsed.first();
        Assert.some("Жан-Поль Сартр", first.author);
        Assert.none(first.filename);
        Assert.some("Тошнота", first.title);
        Assert.some("epub", first.extension);
        Assert.some("4ede07f1b7faede993f8a11d5a062a46", first.md5);
    }
}
