package ru.yandex.chemodan.util.servicemap;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class HttpComponentConnection {
    public final String name;
    public final Option<String> hostname;
    public final ListF<String> monicaMetricPrefix;

    public HttpComponentConnection(String name, Option<String> hostname, ListF<String> monicaMetricPrefix) {
        this.name = name;
        this.hostname = hostname;
        this.monicaMetricPrefix = monicaMetricPrefix;
    }

    public HttpComponentConnection(String name, Option<String> hostname) {
        this.name = name;
        this.hostname = hostname;
        this.monicaMetricPrefix = Cf.list();
    }
}
