package ru.yandex.chemodan.util.servicemap;

import javax.annotation.PostConstruct;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.spring.ApplicationContextUtils;
import ru.yandex.misc.spring.Service;

/**
 * @author tolmalev
 */
public class HttpConfiguratorsCollector implements ApplicationContextAware, Service {
    private ApplicationContext applicationContext;
    private ListF<HttpClientConfigurator> configurators = Cf.list();

    @PostConstruct
    public void init() {
        configurators = ApplicationContextUtils.beansOfType(applicationContext, HttpClientConfigurator.class);
    }

    public ListF<HttpComponentConnection> getConnections() {
        return configurators.map(configurator -> new HttpComponentConnection(
                configurator.getOverridableValuePrefix(),
                Cf.x(PropertiesHolder.properties()).entries().findBy1(propertyName -> {
                    return propertyName.startsWith(configurator.getOverridableValuePrefix() + ".")
                            && (propertyName.contains("url") || propertyName.contains("host"));
                }).flatMapO(t2 -> {
                    String propertyValue = t2._2;

                    propertyValue = StringUtils.removeStart(propertyValue, "http://");
                    propertyValue = StringUtils.removeStart(propertyValue, "https://");
                    propertyValue = StringUtils.substringBefore(propertyValue, "/");
                    propertyValue = StringUtils.substringBefore(propertyValue, "?");

                    return Option.of(propertyValue);
                }),
                configurator.groupName(null).namePrefix.asList()
        ));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void start() throws Exception {
        init();
    }

    @Override
    public void stop() throws Exception {
    }
}
