package ru.yandex.chemodan.util.servicemap;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class JdbcComponentConnection {
    public final String name;
    public final Type type;
    public final Option<String> sharpeiHost;
    public final ListF<String> monicaMetricPrefix;

    public final ListF<ShardInfo> shards;

    public JdbcComponentConnection(String name, Type type, Option<String> sharpeiHost, ListF<String> monicaMetricPrefix, ListF<ShardInfo> shards) {
        this.name = name;
        this.type = type;
        this.sharpeiHost = sharpeiHost;
        this.monicaMetricPrefix = monicaMetricPrefix;
        this.shards = shards;
    }

    public JdbcComponentConnection(String name, Type type, Option<String> sharpeiHost, ListF<ShardInfo> shards) {
        this(name, type, sharpeiHost, Cf.list(), shards);
    }

    @Data
    @BenderBindAllFields
    public static class ShardInfo {
        public final int id;
        public final String name;
        public final ListF<String> hostPortDbNames;
    }

    public enum Type {
        SHARPEI,
        ZK_DYNAMIC,
        STATIC,
        UNKNOWN
    }
}
