package ru.yandex.chemodan.util.servicemap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.admin.web.Admin;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author tolmalev
 */
@Configuration
public class ServiceMapContextConfiguration {
    @Admin
    @Autowired
    private SingleWarJetty adminJetty;

    @Bean
    public ServiceMapServlet serviceMapServlet() {
        ServiceMapServlet servlet = new ServiceMapServlet(httpConfiguratorsCollector(), dataSourceCollector());
        adminJetty.addServletMapping("/m/service_map", servlet);
        return servlet;
    }

    @Bean
    public HttpConfiguratorsCollector httpConfiguratorsCollector() {
        return new HttpConfiguratorsCollector();
    }

    @Bean
    public DataSourceCollector dataSourceCollector() {
        return new DataSourceCollector();
    }
}
