package ru.yandex.chemodan.util.servicemap;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author tolmalev
 */
public class ServiceMapServlet extends HttpServlet {
    private final HttpConfiguratorsCollector httpConfiguratorsCollector;
    private final DataSourceCollector dataSourceCollector;

    private final BenderJsonSerializer<ServiceMap> serviceMapSerializer = Bender.jsonSerializer(ServiceMap.class);

    public ServiceMapServlet(HttpConfiguratorsCollector httpConfiguratorsCollector, DataSourceCollector dataSourceCollector) {
        this.httpConfiguratorsCollector = httpConfiguratorsCollector;
        this.dataSourceCollector = dataSourceCollector;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletResponseX respX = HttpServletResponseX.wrap(resp);

        ServiceMap serviceMap = new ServiceMap(
                httpConfiguratorsCollector.getConnections(),
                dataSourceCollector.getConnections()
        );

        respX.setContentType("application/json");
        serviceMapSerializer.serializeJson(serviceMap, new OutputStreamOutputStreamSource(respX.getOutputStream()));
        respX.flushBuffer();
    }
}
