package ru.yandex.chemodan.util.sharpei;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.db.shard.ShardInfo;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DynamicShardMetaNotifierTest {

    @Test
    public void shardChanged() throws Exception {
        ShardInfo shard1 = new ShardInfo();
        ShardInfo shard2 = new ShardInfo();

        shard1.setReaderHostPortDbnames(Cf.list("h1", "h2", "h3").map(this::hostPortDbName));
        shard1.setWriterHostPortDbname(hostPortDbName("h4"));

        shard2.setReaderHostPortDbnames(Cf.list("h1", "h2", "h3").map(this::hostPortDbName));
        shard2.setWriterHostPortDbname(hostPortDbName("h4"));

        Assert.isFalse(DynamicShardMetaNotifier.shardChanged(shard1, shard2));


        shard2.setWriterHostPortDbname(hostPortDbName(""));

        Assert.isTrue(DynamicShardMetaNotifier.shardChanged(shard1, shard2));


        shard2.setReaderHostPortDbnames(Cf.list("h1", "h2", "h3", "h4").map(this::hostPortDbName));
        shard2.setWriterHostPortDbname(hostPortDbName(""));

        Assert.isFalse(DynamicShardMetaNotifier.shardChanged(shard1, shard2));
    }

    @Test
    public void testMasterChange() throws Exception {
        ShardInfo shard1 = new ShardInfo();
        ShardInfo shard2 = new ShardInfo();

        shard1.setReaderHostPortDbnames(Cf.list("h1", "h2").map(this::hostPortDbName));
        shard1.setWriterHostPortDbname(hostPortDbName("h3"));

        shard2.setReaderHostPortDbnames(Cf.list("h1", "h3").map(this::hostPortDbName));
        shard2.setWriterHostPortDbname(hostPortDbName("h2"));

        Assert.isTrue(DynamicShardMetaNotifier.shardChanged(shard1, shard2));
    }

    @Test
    public void testDiffReaderHostsOrder() throws Exception {
        ShardInfo shard1 = new ShardInfo();
        ShardInfo shard2 = new ShardInfo();

        shard1.setReaderHostPortDbnames(Cf.list("h1", "h2").map(this::hostPortDbName));
        shard1.setWriterHostPortDbname(hostPortDbName("h3"));

        shard2.setReaderHostPortDbnames(Cf.list("h2", "h1").map(this::hostPortDbName));
        shard2.setWriterHostPortDbname(hostPortDbName("h3"));

        Assert.isFalse(DynamicShardMetaNotifier.shardChanged(shard1, shard2));
    }

    private String hostPortDbName(String host) {
        if (host == null || StringUtils.isBlank(host)) {
            return "";
        }
        return ShardInfo.dsUrlPart(host, 6432, "api_disk_data");
    }
}
