package ru.yandex.chemodan.util.sharpei;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class SharpeiDatabaseInfo extends DefaultObject {
    private final Role role;
    private final Status status;
    private final State state;
    private final Address address;

    public SharpeiDatabaseInfo(Role role, Status status, State state, Address address) {
        this.role = role;
        this.status = status;
        this.state = state;
        this.address = address;
    }

    public boolean isMaster() {
        return role == Role.MASTER;
    }

    public boolean isReplica() {
        return !isMaster();
    }

    public boolean isAlive() {
        return !Status.DEAD.equals(status); //it is more safe to compare with dead
    }

    public String getHostPortDbName() {
        return StringUtils.format("{}:{}/{}", address.host, address.port, address.dbname);
    }

    public enum Role {
        REPLICA,
        MASTER
    }

    public enum Status {
        ALIVE,
        DEAD
    }

    @BenderBindAllFields
    public static final class State extends DefaultObject {
        final long lag;

        public State(int lag) {
            this.lag = lag;
        }
    }

    @BenderBindAllFields
    public static final class Address extends DefaultObject {
        final String host;
        final int port;
        final String dbname;
        final String dataCenter;

        public Address(String host, int port, String dbname, String dataCenter) {
            this.host = host;
            this.port = port;
            this.dbname = dbname;
            this.dataCenter = dataCenter;
        }
    }
}
