package ru.yandex.chemodan.util.sharpei;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@Data
public class SharpeiShardInfo {
    private final int id;
    private final String name;
    private final ListF<SharpeiDatabaseInfo> databases;

    public Option<String> getMasterHostPortDbname() {
        return databases.find(SharpeiDatabaseInfo::isMaster).map(SharpeiDatabaseInfo::getHostPortDbName);
    }

    public ListF<String> getReplicaHostPortDbnames() {
        return databases.filter(SharpeiDatabaseInfo::isReplica).map(SharpeiDatabaseInfo::getHostPortDbName);
    }
}
