package ru.yandex.chemodan.util.sharpei;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.db.shard.ShardInfo;

/**
 * @author tolmalev
 */
public class SharpeiShardInfoSource implements ShardInfoSource {
    private final SharpeiClient sharpeiClient;

    public SharpeiShardInfoSource(SharpeiClient sharpeiClient) {
        this.sharpeiClient = sharpeiClient;
    }

    public String getSharpeiBaseUrl() {
        return sharpeiClient.getSharpeiBaseUrl();
    }

    @Override
    public ListF<ShardInfo> getShards() {
        return sharpeiClient.getShards().map(shard ->
                createShardInfo(shard)
        );
    }

    ShardInfo createShardInfo(SharpeiShardInfo shard) {
        ShardInfo info = new ShardInfo();

        info.setId(shard.getId());
        info.setName(shard.getName());

        info.setWriterHostPortDbname(shard.getMasterHostPortDbname().getOrElse(() -> shard.getReplicaHostPortDbnames().first()));
        info.setReaderHostPortDbnames(shard.getReplicaHostPortDbnames());

        return info;
    }
}
