package ru.yandex.chemodan.util.sharpei;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.db.shard.ShardInfo;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class SharpeiShardInfoSourceTest {

    @Test
    public void createShardInfo() {
        SharpeiShardInfoSource shardInfoSource = new SharpeiShardInfoSource(Mockito.mock(SharpeiClient.class));
        ListF<SharpeiDatabaseInfo> sharpeiDatabaseInfos = Cf.arrayList(new SharpeiDatabaseInfo(
                SharpeiDatabaseInfo.Role.MASTER,
                SharpeiDatabaseInfo.Status.ALIVE,
                new SharpeiDatabaseInfo.State(0),
                new SharpeiDatabaseInfo.Address("host", 3642, "name", "mock-master")));
        ShardInfo info = shardInfoSource.createShardInfo(new SharpeiShardInfo(1, "mock", sharpeiDatabaseInfos));
        Assert.notNull(info);
        Assert.notEmpty(info.getWriterHostPortDbname());
    }
}
