package ru.yandex.chemodan.util.sharpei;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.jdbc.ConductorDbListUtils;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.db.shard.ShardInfo;
import ru.yandex.inside.admin.conductor.GroupOrHost;

/**
 * @author tolmalev
 */
public class StaticShardInfoSource implements ShardInfoSource {
    private final LocationResolver locationResolver;
    private final DataSourceProperties dataSourceProperties;

    public StaticShardInfoSource(LocationResolver locationResolver, DataSourceProperties dataSourceProperties) {
        this.locationResolver = locationResolver;
        this.dataSourceProperties = dataSourceProperties;
    }

    @Override
    public ListF<ShardInfo> getShards() {
        ListF<ShardInfo> shards = GroupOrHost.parseListFromString(dataSourceProperties.getHosts())
                .flatMap(groupOrHost -> ConductorDbListUtils.getConfiguration(
                        locationResolver, groupOrHost,
                        dataSourceProperties.getPort(),
                        dataSourceProperties.getDbName()));

        shards.forEach(s -> s.setName(dataSourceProperties.getPropertyPrefix().toXmlName()));

        return shards;
    }
}
