package ru.yandex.chemodan.util.spring;

import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringValueResolver;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.property.PropertiesHolder;

/**
 * @author yashunsky
 */
public class MapProperties implements EmbeddedValueResolverAware {
    private MapF<String, String> tokens;
    private StringValueResolver valueResolver;
    private final ListF<String> keys;
    private final String prefix;

    public MapProperties(String prefix) {
        this.keys = Cf.arrayList();
        this.prefix = prefix + ".";
        this.tokens = Cf.map();

        PropertiesHolder.properties().keySet().iterator().forEachRemaining(o -> {
            String s = String.valueOf(o);
            if (s.startsWith(this.prefix)) {
                this.keys.add(s);
            }
        });

    }

    public MapF<String, String> get () {
        int prefixLength = prefix.length();
        if (tokens.isEmpty()) {
            tokens = keys.toMap(
                    k -> k.substring(prefixLength, k.length()), k -> valueResolver.resolveStringValue("${" + k + "}"));
        }
        return tokens;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.valueResolver = resolver;
    }
}
