package ru.yandex.chemodan.util.tskv;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.log.utils.TskvEscapeUtils;

/**
 * @author Lev Tolmachev
 */
public class TskvUtils {

    static String decodeValue(String line) {

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < line.length(); i++) {
            char c = line.charAt(i);
            if (i == line.length() - 1 || c != '\\') {
                sb.append(c);
            } else {
                char next = line.charAt(i + 1);
                i++;
                if (next == 't') {
                    sb.append('\t');
                } else if (next == '0') {
                    sb.append('\0');
                } else if (next == 'n') {
                    sb.append('\n');
                } else if (next == 'r') {
                    sb.append('\r');
                } else if (next == '\"') {
                    sb.append('"');
                } else if (next == '\\') {
                    sb.append('\\');
                } else {
                    sb.append(c);
                    sb.append(next);
                }
            }
        }
        return sb.toString();
    }

    public static MapF<String, String> extractTskv(String line) {
        return Cf.x(line.split("\t"))
                .filter(Cf.String.containsF("="))
                .toMap(s -> {
                    int i = s.indexOf('=');
                    String key = s.substring(0, i);
                    String value = decodeValue(s.substring(i + 1));
                    return new Tuple2<>(key, value);
                });
    }

    public static String formatTskvLine(MapF<String, String> data) {
        return formatTskvLine(data, true);
    }

    public static String formatTskvLine(MapF<String, String> data, boolean includeTskvPrefix) {
        return data.entries()
                .map((key, value) -> key + "=" + TskvEscapeUtils.escapeWithBackslash(value))
                .mkString(includeTskvPrefix ? "tskv\t": "", "\t", "");
    }

    public static Option<Long> extractUidO(String line) {
        return extractTskv(line)
                .getO("uid")
                .flatMapO(Cf.Long::parseSafe);
    }
}
