package ru.yandex.chemodan.util.tskv;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class TskvUtilsTest {

    @Test
    public void decodeValue() {
        Assert.equals("\t", TskvUtils.decodeValue("\\t"));
        Assert.equals("\n", TskvUtils.decodeValue("\\n"));
        Assert.equals("\0", TskvUtils.decodeValue("\\0"));
        Assert.equals("\r", TskvUtils.decodeValue("\\r"));
        Assert.equals("\"", TskvUtils.decodeValue("\\\""));
        Assert.equals("\\", TskvUtils.decodeValue("\\\\"));
    }

    @Test
    public void extractTskv() {
        Assert.equals(
                Cf.map("asdf", "rewrer", "test", "\tasads\t"),
                TskvUtils.extractTskv("asdf=rewrer\ttest=\\tasads\\t")
        );
    }

    @Test
    public void formatTskvWithPrefix() {
        Assert.equals(
                "tskv\ta=b\tc=d",
                TskvUtils.formatTskvLine(Cf.map("a", "b", "c", "d"))
        );
        Assert.equals(
                "tskv\ta=b\\nc",
                TskvUtils.formatTskvLine(Cf.map("a", "b\nc"))
        );
        Assert.equals(
                "tskv\ta=b\\tc",
                TskvUtils.formatTskvLine(Cf.map("a", "b\tc"))
        );
        // '=' mustn't be escaped
        Assert.equals(
                "tskv\ta=b=c",
                TskvUtils.formatTskvLine(Cf.map("a", "b=c"))
        );
    }

    @Test
    public void formatTskvWithNoPrefix() {
        Assert.equals(
                "a=b\tc=d",
                TskvUtils.formatTskvLine(Cf.map("a", "b", "c", "d"), false)
        );
    }
}
