<xsl:stylesheet version="2.0"
                xmlns:ya="urn:yandex-functions"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/type-settings/common.js"/>
        <script type="text/javascript" src="/z/r/type-settings/jquery.confirm.min.js"/>
        <script type="text/javascript">
            function removeSettings(clientId) {
                $.confirm({
                    text: "Are you sure you want to delete settings for client " + clientId + "?",
                    title: "Confirmation required",
                    confirm: function(button) {
                        $.ajax({
                            url: '/z/tvm-clients/remove?tvmClientId=' + clientId,
                            type: 'POST'
                        }).done(function() {
                            location.reload();
                        })
                    },
                    cancel: function(button) {
                        // nothing to do
                    },
                    confirmButton: "Yes",
                    cancelButton: "No",
                    //post: true,
                    confirmButtonClass: "btn-danger",
                    cancelButtonClass: "btn-default",
                    dialogClass: "modal-dialog modal-lg" // Bootstrap classes for large modal
                });
            }
            $('.edit-link').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.view').hide().end()
                    .find('.edit').show().end();
                return false;
            });
            $('.cancel-button').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.edit').hide().end()
                    .find('.view').show().end();
                return false;
            });
            $('.view-edit-container .edit').hide();
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <h2>Tvm clients</h2>
                <table class="table table-striped table-condensed table-bordered">
                    <tr>
                        <th width="5%" nowrap="true">
                            Client id
                        </th>
                        <th nowrap="true">
                            Internal app name
                        </th>
                        <th nowrap="true">
                            Allow set any app
                        </th>
                        <th nowrap="true">
                            Allow set any uid
                        </th>
                        <th width="50%">
                            Description
                        </th>
                        <th width="100%"/>
                    </tr>
                    <xsl:apply-templates select="elements/element"/>
                </table>

                <br/>
                <br/>
                <br/>
                <h2>Добавить нового клиента</h2>

                <form method="POST" action="/z/tvm-clients/replace">
                    <div class="form-group">
                        <label for="client-id">Client id:</label>
                        <input class="form-control" name="tvm-client-id" id="client-id" type="number" placeholder="global"/>

                        <label for="internal-app-name">Internal app name:</label>
                        <input class="form-control" name="internal-app-id" id="internal-app-name" type="text" placeholder="*"/>

                        <label for="allow-set-any-app">Allow set any app:</label>
                        <input type="checkbox" class="form-control" name="allowSetAnyApp" id="allow-set-any-app" onchange="this.value=this.checked"/>

                        <label for="allow-set-any-uid">Allow set any uid:</label>
                        <input type="checkbox" class="form-control" name="allowSetAnyUid" id="allow-set-any-uid" onchange="this.value=this.checked"/>

                        <label for="description">Description:</label>
                        <input class="form-control" name="description" id="description" type="text" placeholder="*"/>
                    </div>
                    <input type="submit" class="btn btn-default" value="Replace"/>
                </form>

            </div>
        </div>

    </xsl:template>

    <xsl:template match="element">
        <tr class="view-edit-container">
            <td>
                <xsl:value-of select="tvm-client-id"/>
            </td>
            <td>
                <xsl:value-of select="internal-app-id"/>
            </td>
            <td>
                <xsl:value-of select="allow-set-any-app"/>
            </td>
            <td>
                <xsl:value-of select="allow-set-any-uid"/>
            </td>
            <td>
                <xsl:value-of select="description"/>
            </td>
            <td class="edit" colspan="3" style="display: none;">
                <form method="POST" action="/z/tvm-clients/replace" class="form-group" style="margin-left: 15px">
                    <input type="hidden" name="tvm-client-id" value="{tvm-client-id}"/>

                    <label for="internal-app-name">Internal app name:</label>
                    <input class="form-control" name="internal-app-id" id="internal-app-name" type="text" placeholder="*" value="{internal-app-id}"/>

                    <label for="allow-set-any-app">Allow set any app:</label>
                    <input type="checkbox" class="form-control" name="allowSetAnyApp" id="allow-set-any-app" value="{allow-set-any-app}" onchange="this.value=this.checked">
                        <xsl:if test="allow-set-any-app='true'">
                            <xsl:attribute name="checked"/>
                        </xsl:if>
                    </input>

                    <label for="allow-set-any-uid">Allow set any uid:</label>
                    <input type="checkbox" class="form-control" name="allowSetAnyUid" id="allow-set-any-uid" value="{allow-set-any-uid}" onchange="this.value=this.checked">
                        <xsl:if test="allow-set-any-uid='true'">
                            <xsl:attribute name="checked"/>
                        </xsl:if>
                    </input>

                    <label for="description">Description:</label>
                    <input class="form-control" name="description" id="description" type="text" value="{description}" placeholder="*"/>

                    <input type="submit" class="btn btn-default btn-sm" value="Update"/>
                    <xsl:text>&#160;</xsl:text>
                    <input type="button" class="cancel-button btn btn-sm" value="Cancel"/>
                </form>
            </td>
            <td class="view">
                <a href="#" class="edit-link">Редактировать</a>
                <xsl:text>&#160;</xsl:text>
                <a href="#" onclick="removeSettings('{encode-for-uri(tvm-client-id)}');">Удалить</a>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>

