package ru.yandex.chemodan.util.tvm;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author tolmalev
 */
@ActionContainer
public class TvmClientsAdminPage {
    private final TvmClientInfoRegistry registry;

    public TvmClientsAdminPage(TvmClientInfoRegistry registry) {
        this.registry = registry;
    }

    @ZAction(defaultAction = true)
    @Path("/tvm-clients")
    public TvmClientsListPojo index() {
        return new TvmClientsListPojo(registry.getAll().toList());
    }

    @Path(value = "/tvm-clients/replace", methods = HttpMethod.POST)
    public void replace(
            @RequestParam("tvmClientId") int clientId,
            @RequestParam("internalAppId") String internalAppId,
            @RequestParam(value = "allowSetAnyApp", required = false) boolean allowSetAnyApp,
            @RequestParam(value = "allowSetAnyUid", required = false) boolean allowSetAnyUid,
            @RequestParam("description") String description)
    {
        registry.put(new TvmClientInfo(clientId, internalAppId, allowSetAnyApp, allowSetAnyUid, description));

        throw new ZRedirectException("/tvm-clients");
    }

    @Path(value = "/tvm-clients/remove", methods = HttpMethod.POST)
    public void remove(@RequestParam("tvmClientId") int clientId) {
        registry.remove(clientId);

        throw new ZRedirectException("/tvm-clients");
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    private static class TvmClientsListPojo {
        @BenderPart(name = "element", wrapperName = "elements")
        private final ListF<TvmClientInfo> clients;

        public TvmClientsListPojo(ListF<TvmClientInfo> clients) {
            this.clients = clients;
        }
    }
}
