package ru.yandex.chemodan.util.tvm;

import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author tolmalev
 */
@Configuration
public class TvmContextConfiguration {

    @Bean
    @SuppressWarnings("SpringJavaAutowiringInspection")
    public TvmClientsAdminPage tvmClientsAdminPage(TvmClientInfoRegistry registry, Optional<AdminApp> adminApp) {
        TvmClientsAdminPage page = new TvmClientsAdminPage(registry);
        adminApp.ifPresent(app -> app.registerAdminPage(Option.of("Tvm"), page));
        return page;
    }
}
