package ru.yandex.chemodan.util.tvm2;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.exceptions.ForeignTvmServiceTicketException;
import ru.yandex.inside.passport.tvm2.exceptions.IncorrectTvmServiceTicketException;
import ru.yandex.inside.passport.tvm2.exceptions.MissingTvmServiceTicketException;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.passport.tvmauth.CheckedServiceTicket;

/**
 * @author bursy
 */
@Deprecated
public class CloudApiTvm2Filter extends Tvm2Filter {

    private final ListF<Integer> cloudApiClientIds;
    private final boolean checkUserTickets;

    public CloudApiTvm2Filter(Tvm2 tvm2, Tvm2CheckingMode tvm2Mode, String tvm2ServletUrlPattern,
            ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers,
            ListF<Integer> cloudApiClientIds, ListF<String> excludedPaths, boolean checkUserTickets)
    {
        super(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths);
        this.cloudApiClientIds = cloudApiClientIds;
        this.checkUserTickets = checkUserTickets;
    }

    @Override
    protected void checkAuthentication(Option<String> serviceTicketStrO, Option<String> userTicketO,
            Option<String> uidStrO, HttpServletRequestX request)
    {
        String serviceTicketStr = serviceTicketStrO.getOrThrow(MissingTvmServiceTicketException::new);
        CheckedServiceTicket ticket = tvm2.checkServiceTicket(serviceTicketStr);
        if (!ticket.booleanValue()) {
            throw new IncorrectTvmServiceTicketException();
        }
        request.setAttribute(TVM_CLIENT_ID_ATTR, ticket.getSrc());

        if (!cloudApiClientIds.containsTs(ticket.getSrc())) {
            throw new ForeignTvmServiceTicketException(cloudApiClientIds, ticket.getSrc());
        }

        if (checkUserTickets) {
            checkUserTicket(userTicketO, uidStrO);
        }
    }
}
