package ru.yandex.chemodan.util.tvm2;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.parse.CommaSeparated;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author bursy
 */
@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class CloudApiTvm2ServletFilterContextConfiguration {

    private final static Logger logger = LoggerFactory.getLogger(CloudApiTvm2ServletFilterContextConfiguration.class);

    @Bean
    protected Tvm2Filter cloudApiFilter(
            @Value("${tvm.filter.cloudapi.mode:-DISABLED}") Tvm2CheckingMode tvm2Mode,
            @Value("${tvm.filter.cloudapi.pattern:-*}") String tvm2ServletUrlPattern,
            @Value("${tvm.filter.cloudapi.uid.param:-__uid}") String uidParamName,
            @Value("${tvm.cloud-api.client-ids}") CommaSeparated cloudApiClientIds,
            @Value("${tvm.filter.cloudapi.excluded-paths}") CommaSeparated excludedPaths,
            @Value("${tvm.cloud-api.check-user-tickets}") boolean checkUserTickets,
            Tvm2 tvm2)
    {
        if (tvm2 == null || tvm2Mode == Tvm2CheckingMode.DISABLED) {
            logger.warn("Tvm is not initialised or disabled, validation will be skipped");
            Validate.isTrue(tvm2Mode != Tvm2CheckingMode.FULL,
                    "Tvm is required by tvm2Mode property: " + tvm2Mode);
            return null;
        }
        ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers = Cf.list(
                requestX -> requestX.getHeaderO(Tvm2ServletFilterContextConfiguration.X_UID),
                requestX -> requestX.getParameterO(uidParamName)
        );
        return new CloudApiTvm2Filter(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers,
                cloudApiClientIds.list.flatMap(Cf.Integer::parseSafe), excludedPaths.list, checkUserTickets);
    }

}
