package ru.yandex.chemodan.util.videoinfo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class VideoInfoFormatter extends AbstractInfoFormatter {

    @Override
    public String format(PassportUid uid, SearchResult.SearchItem item) {
        String creationDate = EMPTY_FIELD;
        if (item.creationTimeInSec.isPresent()) {
            creationDate = DATE_FORMATTER.print(item.creationTimeInSec.get() * 1000);
        }

        String widthAndHeight = EMPTY_FIELD;
        if (item.width.isPresent() && item.height.isPresent()) {
            widthAndHeight = item.width.get() + "x" + item.height.get();
        }
        return StringUtils.format(
                "{}\t{}\t{}\t{}\t{}\t{}\t{}",
                uid,
                item.path.getOrElse(EMPTY_FIELD),
                DATE_FORMATTER.print(item.mtimeInSec.get() * 1000),
                item.size.map(Cf.Long.toStringF()).getOrElse(EMPTY_FIELD),
                creationDate,
                widthAndHeight,
                item.ratio.getOrElse(EMPTY_FIELD));
    }
}
