package ru.yandex.chemodan.util.videoinfo;

import java.io.IOException;
import java.io.Writer;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.AbstractSearchInfoGrabber;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author akirakozov
 */
public class VideoInfoGrabber extends AbstractSearchInfoGrabber {
    private static final AbstractInfoFormatter formatter = new VideoInfoFormatter();

    public VideoInfoGrabber(String outputFile) {
        super(outputFile);
    }

    public static void main(String[] args) throws IOException {
        Log4jHelper.configureTestLogger();

        if (args.length < 1) {
            System.out.println("Enter input file name!");
            return;
        }

        VideoInfoGrabber grabber = new VideoInfoGrabber("video-info.log");
        grabber.grabInfoForUids(args[0]);
    }

    @Override
    protected void grabInfoForUid(PassportUid uid, Writer out) throws IOException {
        SearchResult result = searchClient.getVideoInfoByUser(uid);
        if (result.items.isEmpty()) {
            out.write(uid + "\n");
        }
        for (SearchResult.SearchItem item : result.items) {
            out.write(formatter.format(uid, item) + "\n");
        }
    }
}
