package ru.yandex.chemodan.util.web;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.chemodan.http.RequestNdcUtil;

/**
 * @author tolmalev
 */
public class AddYcridToHeadersFilter extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException
    {
        RequestNdcUtil.getNdcO(request)
                .filterMap(m -> m.getO("ycrid"))
                .ifPresent(ycrid -> response.addHeader("Yandex-Cloud-Request-ID", ycrid));
        filterChain.doFilter(request, response);
    }
}
