package ru.yandex.chemodan.util.web;

import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.BenderParameterBinder;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.io.SimpleInputStreamSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class BenderJsonParameterBinder extends BenderParameterBinder {

    private final BenderMapper benderMapper;

    public BenderJsonParameterBinder(BenderMapper benderMapper) {
        super(benderMapper);
        this.benderMapper = benderMapper;
    }

    @Override
    public Object createAndBind(WebRequest request, ActionInvocationContext invocationContext,
            ParameterDescriptor descriptor)
    {
        Class<?> clazz = descriptor.getParameterType().getRawType().erasure().getClazz();
        try {
            return benderMapper
                    .parseJson(clazz, new SimpleInputStreamSource(request.getHttpServletRequest().getInputStreamX()));
        } catch (RuntimeException e) {
            throw new A3ExceptionWithStatus("cant-parse", e, HttpStatus.SC_400_BAD_REQUEST);
        }
    }
}
