package ru.yandex.chemodan.util.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandlerOrders;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.db.masterSlave.MasterSlaveUnitUnavailableException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class MasterSlaveUnavailableExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(WebRequest webRequest,
            ActionInvocationContext invocationContext, ExceptionResolver exceptionResolver,
            Exception exception)
    {
        if (exception instanceof MasterSlaveUnitUnavailableException) {
            webRequest.getHttpServletResponse().setStatus(HttpStatus.SC_503_SERVICE_UNAVAILABLE);
            return Option.of(ErrorResult.fromNameAndThrowable("read-only", exception));
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
