package ru.yandex.chemodan.util.web;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.lang.StringUtils;

public class Tvm2UidParameterBinder implements ParameterBinder {

    @Nullable
    @Override
    public Object createAndBind(WebRequest webRequest, ActionInvocationContext invocationContext,
            ParameterDescriptor parameterDescriptor)
    {
        Object attribute = webRequest.getHttpServletRequest().getAttribute(Tvm2Filter.TVM_UID_ATTR);
        String uidStr = attribute != null ? attribute.toString() : null;
        Option<Long> uid = StringUtils.isNumericArabic(uidStr) ? Option.of(Long.valueOf(uidStr)) : Option.empty();

        return PassportUidOrZero.fromUidO(uid.map(PassportUid::new));
    }
}
