package ru.yandex.chemodan.util.web.interceptors;

import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.cache.tl.TlCache;

/**
 * @author dbrylev
 */
public class ThreadLocalCacheInterceptor implements ActionInvocationInterceptor {

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        if (invocation.getActionDescriptor().hasAnnotation(WithThreadLocalCache.class)) {
            TlCache.Handle handle = TlCache.push();
            try {
                return invocation.invoke();
            } finally {
                handle.popSafely();
            }
        } else {
            return invocation.invoke();
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
