package ru.yandex.chemodan.util.yasm;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.lang.Check;

/**
 * @author tolmalev
 */
public class HistUnistatSensor extends UnistatSensor<ListF<Tuple2<Double, Long>>> {
    private final ListF<Tuple2<Double, Long>> histogramData;

    public HistUnistatSensor(String name, AggregationType aggregationType,
            ListF<Tuple2<Double, Long>> histogramData)
    {
        super(name, aggregationType);
        Check.in(aggregationType, Cf.list(AggregationType.ABSOLUTE_HGRAM, AggregationType.HGRAM));

        this.histogramData = histogramData;
    }

    /**
     * [[left_boundary, weight], ...]
     * @see https://wiki.yandex-team.ru/golovan/stat-handle/
     */
    @Override
    protected void writeValue(BenderJsonWriter json) {
        json.writeArrayStart();
        histogramData.forEach(t2 -> {
            json.writeArrayStart();
            json.writeNumber(t2._1);
            json.writeNumber(t2._2);
            json.writeArrayEnd();
        });
        json.writeArrayEnd();
    }

    @Override
    public ListF<Tuple2<Double, Long>> getValue() {
        return histogramData;
    }
}
