package ru.yandex.chemodan.util.yasm;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.monica.core.blocks.AverageData;
import ru.yandex.misc.monica.core.blocks.Instrument;
import ru.yandex.misc.monica.core.blocks.InstrumentedData;
import ru.yandex.misc.monica.util.measure.MeasureInfo;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class MonicaSnapshotAggregatorForYasmTest {

    @Test
    public void sensorsForAverage() {
        AverageData avg = new AverageData(1, 2, 3, 100);
        ListF<UnistatSensor> average = MonicaSnapshotAggregatorForYasm.avgSensorsForAverage(avg, "average");

        Assert.sizeIs(3, average);

        Assert.equals(new SimpleUnistatSensor("average_1min", 1, UnistatSensor.AggregationType.AVERAGE_VALUE),
                average.get(0));

        Assert.equals(new SimpleUnistatSensor("average_5min", 2, UnistatSensor.AggregationType.AVERAGE_VALUE),
                average.get(1));

        Assert.equals(new SimpleUnistatSensor("average_15min", 3, UnistatSensor.AggregationType.AVERAGE_VALUE),
                average.get(2));


        ListF<UnistatSensor> total = MonicaSnapshotAggregatorForYasm.totalSensorsForAverage(avg, "average");

        Assert.sizeIs(1, total);
        Assert.equals(new SimpleUnistatSensor("average", 100, UnistatSensor.AggregationType.SUMM),
                total.get(0));
    }

    @Test
    public void sensorsForStatistics() {
        Instrument in = new Instrument();
        in.tick(0);
        for (int i = 1; i <= 60 * 1000; i++) {
            in.update(new MeasureInfo(Duration.millis((i % 60) * 10), true));
            if (i % 5 == 0) {
                in.tick(1000 * i);
            }
        }

        InstrumentedData iData = in.apply();
        System.out.print(iData);

        ListF<UnistatSensor> sensors =
                MonicaSnapshotAggregatorForYasm.sensorsForStatistics(iData.statisticData(), "stat");

        Assert.sizeIs(2, sensors);
    }
}
