package ru.yandex.chemodan.util.yasm;

import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.monica.core.name.FullMetricName;

/**
 * @author Maksim Leonov
 */
public class MonicaYasmConfiguration {
    public static final MonicaYasmConfiguration DEFAULT = new MonicaYasmConfiguration(
            Function1B.trueF()
    );

    private final Function1B<FullMetricName> metricFilter;

    /**
     * @param metricFilter        is used to filter metrics _before_ they are converted to yasm format.
     */
    public MonicaYasmConfiguration(Function1B<FullMetricName> metricFilter) {
        this.metricFilter = metricFilter;
    }

    public Function1B<FullMetricName> getMetricFilter() {
        return metricFilter;
    }
}
