package ru.yandex.chemodan.util.yasm;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.admin.web.Admin;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.misc.monica.service.MonicaLocalSnapshotSupplier;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author tolmalev
 */
@Configuration
public class MonicaYasmContextConfiguration {
    @Admin
    @Autowired
    private SingleWarJetty adminJetty;
    @Autowired
    private ZkManager zkManager;

    @Bean
    public YasmUnistatServlet yasmUnistatServlet(MonicaSnapshotAggregatorForYasm aggregator) {
        YasmUnistatServlet servlet = new YasmUnistatServlet(aggregator);
        adminJetty.addServletMapping("/m/yasm/unistat/my", servlet);
        return servlet;
    }

    @Bean
    public MonicaSnapshotAggregatorForYasm monicaSnapshotAggregatorForYasm(
            MonicaLocalSnapshotSupplier monicaLocalSnapshotSupplier,
            YasmMetricsRegistry yasmMetricsRegistry)
    {
        MonicaSnapshotAggregatorForYasm aggregator =
                new MonicaSnapshotAggregatorForYasm(new MonicaYasmConfiguration(yasmMetricsRegistry));

        monicaLocalSnapshotSupplier.registerConsumer(aggregator::storeSnapshot);

        return aggregator;
    }

    @Bean
    public YasmMetricsRegistry yasmMetricsRegistry(@Qualifier("zkRoot") ZkPath zkRoot) {
        YasmMetricsRegistry registry = new YasmMetricsRegistry(zkRoot.child("yasm/registry"));
        zkManager.addClient(registry);
        return registry;
    }
}
