package ru.yandex.chemodan.util.yasm;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public abstract class UnistatSensor<T> extends DefaultObject {

    private final String name;
    private final AggregationType aggregationType;
    private final boolean useCustomAggregation;

    public UnistatSensor(String name, AggregationType aggregationType) {
        this.name = name;
        this.aggregationType = aggregationType;
        this.useCustomAggregation = name.matches(".*_([ad][vehmntx]{3}|summ|hgram|max)$");
    }

    /**
     * ["metric_name", metric-value]
     * @see https://wiki.yandex-team.ru/golovan/stat-handle/
     */
    public void writeTo(BenderJsonWriter json) {
        json.writeArrayStart();
        json.writeString(useCustomAggregation ? name : name + "_" + aggregationType.getSigopt());
        writeValue(json);
        json.writeArrayEnd();
    }

    public boolean usesCustomAggregationForTest() {
        return useCustomAggregation;
    }

    public abstract T getValue();

    protected abstract void writeValue(BenderJsonWriter json);

    /**
     * @see https://wiki.yandex-team.ru/golovan/userdocs/aggregation-types/
     */
    public enum AggregationType {
        AVERAGE_VALUE("ammv"),
        ABSOLUTE_HGRAM("ahhh"),
        SUMM("summ"),
        HGRAM("hgram")
        ;

        private final String sigopt;

        AggregationType(String sigopt) {
            this.sigopt = sigopt;
        }

        public String getSigopt() {
            return sigopt;
        }
    }
}
