package ru.yandex.chemodan.util.yasm;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.monica.core.name.FullMetricName;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author tolmalev
 */
public class YasmMetricsRegistry extends ZkRegistry<String, YasmMetricsRegistry.MetricEntry>
        implements Function1B<FullMetricName>
{
    private ListF<Pattern2> compiledPatterns = Cf.list();

    public YasmMetricsRegistry(ZkPath path) {
        super(path, Bender.cons(MetricEntry.class), MetricEntry::getPattern, s -> s);
        addListener(state -> {
            compiledPatterns = state.map(entry -> Pattern2.compile(entry.pattern));
        });
    }

    public void addPattern(String pattern) {
        put(new MetricEntry(pattern));
    }

    public void removePattern(String pattern) {
        remove(pattern);
    }

    @Override
    public boolean apply(FullMetricName fullMetricName) {
        String metricNameStr = fullMetricName.asList().mkString(".");
        return compiledPatterns.exists(p -> p.matches(metricNameStr));
    }

    @BenderBindAllFields
    static final class MetricEntry extends DefaultObject {
        public final String pattern;

        MetricEntry(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return pattern;
        }
    }
}
