package ru.yandex.chemodan.util.yasm;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author tolmalev
 */
public class YasmUnistatServlet extends HttpServlet {
    private final YasmSensorsDataProducer sensorsDataProducer;
    private final YasmUnistatJsonSerializer serializer;

    public YasmUnistatServlet(YasmSensorsDataProducer sensorsDataProducer) {
        this.sensorsDataProducer = sensorsDataProducer;
        this.serializer = new YasmUnistatJsonSerializer();
    }

    @Override
    protected void doGet(HttpServletRequest req0, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json; charset=utf-8");
        serializer.serialize(sensorsDataProducer.getSensors(), resp.getOutputStream());
    }
}
