package ru.yandex.chemodan.util.yasm.monitor;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Try;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.thread.ThreadUtils;

/**
 * @author yashunsky
 */
public class MetricAverageTest {
    private final static Duration MAX_INTERVAL = Duration.standardSeconds(1);
    private MetricAverage metricAverage;

    @Before
    public void before() {
        metricAverage = new MetricAverage(MAX_INTERVAL);
    }

    @Test
    public void countAverage() {
        Duration interval = Duration.millis(100);

        Function0<Double> getAverage =
                () -> metricAverage.getAverage(interval.multipliedBy(2), ts -> new RuntimeException());

        //warm up
        metricAverage.update(0);
        ThreadUtils.sleep(MAX_INTERVAL);

        metricAverage.update(1);
        Instant firstPointAdded = Instant.now();
        ThreadUtils.sleep(interval);
        metricAverage.update(2);
        ThreadUtils.sleep(interval);
        metricAverage.update(3);

        ThreadUtils.sleep(10);
        double average = getAverage.apply();
        Assert.equals(2.5, average, 0.01);

        ThreadUtils.sleep(interval);
        average = getAverage.apply();
        Assert.equals(3, average, 0.01);

        Assert.equals(3, metricAverage.getPointsCountForTest());

        ThreadUtils.sleep(MAX_INTERVAL.minus(new Duration(firstPointAdded, Instant.now())));

        Assert.failure(Try.tryCatchException(getAverage), RuntimeException.class);
        Assert.equals(2, metricAverage.getPointsCountForTest());
    }
}
