package ru.yandex.chemodan.util.yasm.monitor;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class NoRelevantValueException extends RuntimeException {
    private NoRelevantValueException(String host, String reason) {
        super("No relevant metrics found for " + host + ". " + reason);
    }

    public static NoRelevantValueException outOfDate(String host, YasmMetric metric, Option<Instant> timestamp) {
        String message = timestamp.map(ts -> "Last " + metric + " metric received at " + ts)
                .getOrElse("No " + metric + " data in buffer");
        return new NoRelevantValueException(host, message);
    }

    public static NoRelevantValueException metricsNotFound(String host, YasmMetric metric) {
        return new NoRelevantValueException(host, "No " + metric + " in snapshot");
    }
}
