package ru.yandex.chemodan.util.yasm.monitor;

import java.io.IOException;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.AllArgsConstructor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.Check;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class YasmAggrClient {
    private final HttpClient httpClient;

    public MapF<YasmMetric, Double> get(String host, ListF<YasmMetricExtractor> extractors) {
        HttpGet request = new HttpGet("http://" + host + ":11003/json/aggr");
        try {
            return httpClient.execute(request, (response) -> {
                String responseBody = EntityUtils.toString(response.getEntity());
                ObjectNode repacked = new ObjectNode(JsonNodeFactory.instance);

                JsonNodeUtils.getNode(responseBody).get("aggr").forEach(node -> {
                    Check.equals(3, node.size(), "Response format differs from key, tags, value");
                    String key = node.get(0).textValue();
                    ObjectNode value = (ObjectNode) node.get(2);
                    if (repacked.has(key)) {
                        ObjectNode existingValue = (ObjectNode) repacked.get(key);
                        value.fields().forEachRemaining(entry -> existingValue.set(entry.getKey(), entry.getValue()));
                    } else {
                        repacked.set(key, value);
                    }
                });

                return extractors.toMap(YasmMetricExtractor::getMetric, e -> e.extract(repacked))
                        .filterValues(Option::isPresent).mapValues(Option::get);
            });
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
