package ru.yandex.chemodan.util.yasm.monitor;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Getter
public enum YasmHostStatus {
    OK(0),
    WARN(1),
    CRIT(2);

    private final int critLevel;

    public boolean isCrit() {
        return this == CRIT;
    }

    public static YasmHostStatus worst(YasmHostStatus a, YasmHostStatus b) {
        return a.critLevel > b.critLevel ? a : b;
    }
}
