package ru.yandex.chemodan.util.yasm.monitor;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public enum YasmMetric {
    IO,
    NETWORK_IN,
    NETWORK_OUT,
    LA,
    CPU_USER,
    PG_QUERY_TIME,
    PG_LAG,
    PG_DEAD_TUP;

    private final Function2<Double, Double, Boolean> worseThen;

    YasmMetric() {
        this((value, limit) -> value > limit);
    }

    public static ListF<YasmMetric> all() {
        return Cf.x(values());
    }

    public boolean worseThen(double value, double limit) {
        return worseThen.apply(value, limit);
    }

    public double worse(double a, double b) {
        return worseThen(a, b) ? a : b;
    }
}
