package ru.yandex.chemodan.util.yasm.monitor;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Data
@BenderBindAllFields
public class YasmMetricRanges {
    private final double warn;
    private final double crit;

    public YasmHostStatus getHostStatus(YasmMetric metric, double value) {
        if (metric.worseThen(value, crit)) {
            return YasmHostStatus.CRIT;
        } else if (metric.worseThen(value, warn)) {
            return YasmHostStatus.WARN;
        }
        return YasmHostStatus.OK;
    }
}
