package ru.yandex.chemodan.util.yt;

import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractTablePath {
    protected final YtHelper yt;

    protected final YPath parentPath;

    public AbstractTablePath(YtHelper yt, YPath parentPath) {
        this.yt = yt;
        this.parentPath = parentPath;
    }

    public abstract String getName();

    public YPath getPath() {
        return parentPath.child(getName());
    }

    public boolean isNotEmpty() {
        return yt.getRowCount(getPath()) > 0;
    }

    public boolean existsAndNotEmpty() {
        return exists() && isNotEmpty();
    }

    private boolean exists() {
        return yt.existsWithRetries(getPath());
    }
}
