package ru.yandex.chemodan.util.yt;

import java.util.function.Supplier;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.specs.CommandSpec;
import ru.yandex.inside.yt.kosher.tables.types.JacksonTableEntryType;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class CustomLogMrYtRunner extends BaseIncrementalLogMrYtRunner {

    private static final Logger logger = LoggerFactory.getLogger(CustomLogMrYtRunner.class);

    private final ListF<YPath> incrementalInputPaths;

    private final Supplier<ListF<YPath>> staticInputPathsSupplier;

    private final YPath outputPath;

    private final Supplier<ListF<String>> additionalMapParametersSupplier;

    public CustomLogMrYtRunner(Yt yt, RetryPolicy retryPolicy, YPath rootPath, String scriptName,
                               ListF<String> reduceKeys, Class<?> classNearScripts, ListF<YPath> incrementalInputPaths,
                               Supplier<ListF<YPath>> staticInputPathsSupplier,
                               YPath outputPath,
                               Supplier<ListF<String>> additionalMapParametersSupplier,
                               YtCommandParameters commandParameters)
    {
        super(yt, retryPolicy, rootPath, scriptName, reduceKeys, classNearScripts, commandParameters, false);
        this.incrementalInputPaths = incrementalInputPaths;
        this.staticInputPathsSupplier = staticInputPathsSupplier;
        this.outputPath = outputPath;
        this.additionalMapParametersSupplier = additionalMapParametersSupplier;
    }

    @Override
    protected CommandSpec getMapCommandSpec() {
        return consBinaryCmd(getMapParameters(), new JacksonTableEntryType(),
                new JacksonTableEntryTypeWithoutUtfEncoding()
        );
    }

    @Override
    protected CommandSpec getReduceCommandSpec() {
        return consBinaryCmd("reduce");
    }

    @Override
    protected YPath outputPath() {
        return outputPath;
    }

    @Override
    protected ListF<YPath> getInputPaths(LocalDate by, int daysBefore) {
        return incrementalInputPaths.flatMap(path -> Cf.range(0, daysBefore + 1).map(dayBefore -> path.child(by.minusDays(dayBefore).toString())))
                .plus(staticInputPathsSupplier.get())
                .filter(yt::existsWithRetries);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected ListF<String> getAdditionalMapParameters() {
        return additionalMapParametersSupplier.get();
    }
}
