package ru.yandex.chemodan.util.yt;

import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.util.date.LocalDateRange;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DateRangeTablePath extends AbstractTablePath {
    @Getter
    private final LocalDateRange dateRange;

    public DateRangeTablePath(YtHelper yt, YPath parentPath, LocalDateRange dateRange) {
        super(yt, parentPath);
        this.dateRange = dateRange;
    }

    @Override
    public String getName() {
        return dateRange.toString();
    }

    public boolean overlaps(LocalDateRange dateRange) {
        return this.dateRange.overlaps(dateRange);
    }

    public boolean includes(LocalDateRange dateRange) {
        return this.dateRange.includes(dateRange);
    }

    public LocalDate getEndDate() {
        return dateRange.getEnd();
    }
}
