package ru.yandex.chemodan.util.yt;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;
import org.joda.time.Period;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yashunsky
 */
public class IncrementalLogMrYtRunner extends BaseIncrementalLogMrYtRunner {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalLogMrYtRunner.class);

    public static MapF<String, YTreeNode> COMPRESSION_ATTRIBUTES = Cf.map(
            "compression_codec", YTree.stringNode("brotli_8"),
            "erasure_codec", YTree.stringNode("lrc_12_2_2")
    );

    private final YPath logsRootPath;
    private final int inspectPeriodDays;
    private final YtCleaner ytCleaner;

    private final String outputName;

    public IncrementalLogMrYtRunner(Yt yt, RetryPolicy retryPolicy, YPath rootPath, Period deletePeriod,
            YPath logsRootPath, int inspectPeriodDays, String scriptName, String outputName, ListF<String> reduceKeys,
            Class<?> classNearScripts)
    {
        super(yt, retryPolicy, rootPath, scriptName, reduceKeys, classNearScripts, new YtCommandParameters(), true);
        this.ytCleaner = new YtCleaner(yt, retryPolicy, deletePeriod);
        this.logsRootPath = logsRootPath;
        this.inspectPeriodDays = inspectPeriodDays;
        this.outputName = outputName;
    }

    public YPath outputPath() {
        return tmpRootYPath().child(outputName).withAdditionalAttributes(COMPRESSION_ATTRIBUTES);
    }

    @Override
    protected ListF<YPath> getInputPaths(LocalDate by, int daysBefore) {
        Option<YPath> prevPath = ytCleaner.deleteOldAndGetLatestNotEmpty(outputPath(), by);
        return ytCleaner.getLogsPaths(by, daysBefore, inspectPeriodDays, prevPath, logsRootPath).plus(prevPath);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
