package ru.yandex.chemodan.util.yt;

import ru.yandex.bolts.function.Function2V;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author yashunsky
 */
public class TableBatchExecutor {
    private final YPath path;
    private final int batchSize;
    private final YtHelper ytRunner;

    public TableBatchExecutor(YtHelper ytRunner, YPath path, int batchSize) {
        this.ytRunner = ytRunner;
        this.path = path;
        this.batchSize = batchSize;
    }

    public void executeByIndexes(Function2V<Long, Long> actionF) {
        long rowCount = ytRunner.getRowCount(path);
        long lowerRowIndex = 0;
        long upperRowIndex;

        while (lowerRowIndex < rowCount) {
            upperRowIndex = lowerRowIndex + batchSize;
            upperRowIndex = upperRowIndex > rowCount ? rowCount : upperRowIndex;

            actionF.apply(lowerRowIndex, upperRowIndex);

            lowerRowIndex = upperRowIndex;
        }
    }
}
