package ru.yandex.chemodan.util.yt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;

import org.joda.time.Instant;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author messiahlap
 */
public class YqlHelper {

    private static final Logger logger = LoggerFactory.getLogger(YqlHelper.class);

    private final String dataSourceUrl;

    private final String token;

    private final String user;

    public YqlHelper(String dataSourceUrl, String token, String user) {
        this.dataSourceUrl = dataSourceUrl;
        this.token = token;
        this.user = user;
        try {
            Class.forName("ru.yandex.yql.YqlDriver");
        } catch (ClassNotFoundException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public boolean execute(String yql) {
        boolean executed;
        try (Connection conn = DriverManager.getConnection(dataSourceUrl, user, token);
             PreparedStatement stmt = conn.prepareStatement(yql))
        {
            Instant start = Instant.now();
            logger.debug("Executing YQL {}", yql);
            executed = stmt.execute();
            logger.debug("Executed YQL {}, took {}", yql, TimeUtils.secondsStringToNow(start));
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
        return executed;
    }
}
