package ru.yandex.chemodan.util.yt;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;
import org.joda.time.Period;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author yashunsky
 */
public class YtCleaner {
    private final Period deletePeriod;
    private final YtHelper ytRunner;

    public YtCleaner(Yt ytRunner, RetryPolicy retryPolicy, Period deletePeriod) {
        this.ytRunner = new YtHelper(ytRunner, retryPolicy);
        this.deletePeriod = deletePeriod;
    }

    public Option<YPath> deleteOldAndGetLatestNotEmpty(YPath path, LocalDate by) {
        Tuple2<ListF<LocalDate>, Option<LocalDate>> existingDatesAndLatestNotEmptyDate =
                ytRunner.getExistingDatesAndLatestNotEmptyDate(path, by);

        LocalDate deleteLimit = by.minus(deletePeriod);

        ListF<LocalDate> existingDates = existingDatesAndLatestNotEmptyDate._1;
        Option<LocalDate> latestNotEmptyDate = existingDatesAndLatestNotEmptyDate._2;

        existingDates.filter(date -> date.isBefore(deleteLimit) && ! latestNotEmptyDate.isSome(date))
                .forEach(date -> ytRunner.runWithRetries(() -> ytRunner.remove(path.child(date.toString()))));

        return latestNotEmptyDate.map(date -> path.child(date.toString()));
    }

    public ListF<YPath> getLogsPaths(
            LocalDate by, int daysBefore, int inspectPeriodDays, Option<YPath> prevPath, YPath logsRootPath)
    {
        if (daysBefore < 0) {
            daysBefore = prevPath.map(path -> new Period(LocalDate.parse(path.name()), by).getDays())
                    .getOrElse(inspectPeriodDays);
            daysBefore = daysBefore > inspectPeriodDays ? inspectPeriodDays : daysBefore;
        }

        return ytRunner.getDailyLogPaths(logsRootPath, by, daysBefore);
    }

}
