package ru.yandex.chemodan.util.yt;

import java.util.function.Supplier;

import lombok.AllArgsConstructor;

import ru.yandex.inside.yt.kosher.common.DataSize;

/**
 * @author friendlyevil
 */
@AllArgsConstructor
public class YtCommandParameters {
    private final Supplier<Integer> memoryLimitMb;
    private final Supplier<Integer> jobCount;

    public YtCommandParameters() {
        this(() -> null, () -> null);
    }

    public DataSize getMemoryLimit() {
        Integer limit = memoryLimitMb.get();
        if (limit == null || limit < 1) {
            return null;
        }

        return DataSize.fromMegaBytes(limit);
    }

    public Integer getJobCount() {
        Integer jobs = jobCount.get();
        if (jobs == null || jobs < 1) {
            return null;
        }

        return jobs;
    }
}
