package ru.yandex.chemodan.util.yt;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.specs.CommandSpec;
import ru.yandex.inside.yt.kosher.tables.types.JacksonTableEntryType;

/**
 * @author yashunsky
 */
public class YtRunnerBase {
    private final YPath rootPath;
    private final String scriptName;
    protected final YtHelper yt;
    protected final YtCommandParameters commandParameters;

    public YtRunnerBase(Yt yt, RetryPolicy retryPolicy, YPath rootPath, String scriptName) {
        this(yt, retryPolicy, rootPath, scriptName, new YtCommandParameters());
    }

    public YtRunnerBase(Yt yt, RetryPolicy retryPolicy, YPath rootPath, String scriptName,
                        YtCommandParameters commandParameters) {
        this.rootPath = rootPath;
        this.scriptName = scriptName;
        this.yt = new YtHelper(yt, retryPolicy);
        this.commandParameters = commandParameters;
    }

    protected CommandSpec consCmd(String command, JacksonTableEntryType inputType, JacksonTableEntryType outputType) {
        return CommandSpec.builder()
                .setCommand(command)
                .setInputType(inputType)
                .setOutputType(outputType)
                .setFiles(scriptsPaths())
                .setMemoryLimit(commandParameters.getMemoryLimit())
                .setJobCount(commandParameters.getJobCount())
                .build();
    }

    protected CommandSpec consPythonCmd(String command) {
        return consPythonCmd(command, new JacksonTableEntryType(), new JacksonTableEntryType());
    }

    protected CommandSpec consPythonCmdWithoutUtfEncoding(String command) {
        return consPythonCmd(command, new JacksonTableEntryTypeWithoutUtfEncoding(), new JacksonTableEntryTypeWithoutUtfEncoding());
    }

    protected CommandSpec consPythonCmd(String params, JacksonTableEntryType inType, JacksonTableEntryType outType) {
        return consCmd(String.format("python %s %s", scriptName, params), inType, outType);
    }

    protected CommandSpec consBinaryCmd(String command) {
        return consBinaryCmd(command, new JacksonTableEntryType(), new JacksonTableEntryType());
    }

    protected CommandSpec consBinaryCmdWithoutUtfEncoding(String command) {
        return consBinaryCmd(command, new JacksonTableEntryTypeWithoutUtfEncoding(), new JacksonTableEntryTypeWithoutUtfEncoding());
    }

    protected CommandSpec consBinaryCmd(String params, JacksonTableEntryType inType, JacksonTableEntryType outType) {
        return consCmd(String.format("./%s %s", scriptName, params), inType, outType);
    }

    protected void uploadScripts() {
        uploadScripts(this.getClass());
    }

    protected void uploadScripts(Class<?> clazz) {
        yt.uploadScriptsWithRetries(clazz, scriptsPaths());
    }

    protected YPath scriptsPath() {
        return rootPath.child("scripts");
    }

    protected YPath tmpRootYPath() {
        return rootPath;
    }

    protected ListF<YPath> scriptsPaths() {
        return Cf.list(scriptsPath().child(scriptName));
    }
}
