package ru.yandex.chemodan.util.yt;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.specs.CommandSpec;
import ru.yandex.inside.yt.kosher.operations.specs.MapReduceSpec;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class YtSpecBuilderTest {
    private static final YTableEntryType DEFAULT_ENTRY_TYPE = YTableEntryTypes.YSON;

    private static final YTableEntryType NO_UTF_ENTRY_TYPE = YTableEntryTypes.JACKSON_UTF8;

    @Test
    public void test() {
        YPath rootPath = YPath.simple("//home");
        YPath scriptPath = rootPath
                .child("scripts")
                .child("script.py");
        YPath inputTable = rootPath.child("input");
        YPath outputTable = rootPath.child("output");

        Assert.equals(
                MapReduceSpec.builder()
                        .setInputTables(Cf.list(inputTable))
                        .setOutputTables(Cf.list(outputTable))
                        .setMapperSpec(CommandSpec.builder()
                                .setCommand("python script.py map")
                                .setInputType(DEFAULT_ENTRY_TYPE)
                                .setOutputType(NO_UTF_ENTRY_TYPE)
                                .setFiles(Cf.list(scriptPath))
                                .build())
                        .setReduceBy(Cf.list("id", "date"))
                        .setReducerSpec(CommandSpec.builder()
                                .setCommand("python script.py reduce")
                                .setInputType(NO_UTF_ENTRY_TYPE)
                                .setOutputType(DEFAULT_ENTRY_TYPE)
                                .setFiles(Cf.list(scriptPath))
                                .build())
                        .build(),
                YtSpecBuilder.python(scriptPath)
                        .inputTable(inputTable)
                        .outputTable(outputTable)
                        .map("map")
                        .outputEntryType(NO_UTF_ENTRY_TYPE)
                        .reduce("reduce")
                        .inputEntryType(NO_UTF_ENTRY_TYPE)
                        .by(Cf.list("id", "date"))
                        .build()
        );
    }
}
